CREATE OR REPLACE FUNCTION TSystem.views__ReportingAuftg__recreate() RETURNS VOID AS $$
BEGIN

    DROP VIEW IF EXISTS treporting.auftg_beleg_positionennachtrag;
    DROP VIEW IF EXISTS treporting.auftg_beleg_positionen;
    CREATE OR REPLACE VIEW treporting.auftg_beleg_positionen AS
     SELECT
      'auftg'::VARCHAR(30)                                          AS position_tablename,
      auftg.dbrid                                                   AS position_dbrid,
      ag_id                                                         AS position_id,
      ag_id                                                         AS position_abzu_join_id,

      ag_astat                                                      AS position_status,
      ag_nr                                                         AS position_identnummer,   --unser auftrag
      ag_pos                                                        AS position_identpos,

      ag_datum                                                      AS datum_erfasst,

      NULL::CHAR(1)                                                 AS referenz_identdatum,
      COALESCE(ag_hwpos, ag_pos::VARCHAR(5))                        AS position_coalesce_handwerker_posnr,

      NULL::CHAR(1)                                                 AS position_status1,      --rechnung : 2. referenz ist auftrag, aus dem der lieferschein war
      ag_kanf_nr                                                    AS position_identnummer1,  --ihre anfrage
      NULL::INTEGER                                                 AS position_identpos1,
      NULL::DATE                                                    AS referenz_identdatum1,

      ag_dokunr                                                     AS position_dokument_id,
      ag_rahmen_ag_id IS NOT NULL                                   AS position_israhmenabruf,
      ag_rahmen_ag_id                                               AS position_rahmen_nr_referenz,
      NULL::INTEGER                                                 AS position_rahmen_abrufnr,


      ag_bda                                                        AS referenz,
      ag_bdapos                                                     AS referenz_pos,
      ag_bdat                                                       AS referenz_vondatum,
      NULL::NUMERIC                                                 AS referenz_menge,              --Lieferschein: Menge Bestellt (Verkauf an Kunde)
      NULL::NUMERIC                                                 AS referenz_menge_erledigt,     --Lieferschein: Menge bereits geliefert

      ag_dispokrzl                                                  AS adresse_ansprechpartner_adressant_kurzzeichen,
      ag_dispo                                                      AS adresse_ansprechpartner_adressant,
      ag_kontakt                                                    AS adresse_ansprechpartner_intern_ident,
      nameAufloesen(ag_kontakt)                                     AS adresse_ansprechpartner_intern_name,

      ag_lkn                                                        AS adresse_adressant,
      ag_krzl                                                       AS adresse_lieferadresse,
      ag_krzf                                                       AS adresse_rechnungsadresse,

      ag_aknr                                                       AS artikelnummer,
      ag_aknr_idx                                                   AS artikelnummer_index,
      ag_aknr_referenz                                              AS artikelnummer_adressant,

      COALESCE(ag_aknr_referenz, ag_aknr)                           AS artikelnummer_coalesce_adressant_intern,
      COALESCE(ag_akbz, lang_artbez(ag_aknr, ReportLang_current()), ak_bez)
                                                                    AS artikelbezeichnung, --prodat_languages.customerlang(ag_lkn)
      COALESCE(ag_akbz, az_bez, lang_artbez(ag_aknr, ReportLang_current()), ak_bez)
                                                                    AS artikelbezeichnung_coalesce_adressant_intern,

      /* Subselect eher so...Gültigkeitsdaten zurzeit ignoriert
      SELECT az_kunr FROM artzuo WHERE az_prokrz=ag_lkn AND az_pronr=ag_aknr
          AND COALESCE(az_gdatum, current_date) <= current_date
          AND COALESCE(az_bisdatum, current_date) >= current_date
        ORDER BY az_gdatum DESC NULLS LAST, az_id LIMIT 1

        */
      ak_znr                                                        AS artikel_zeichnungsnummer,
      COALESCE(lang_artdim(ag_aknr, ReportLang_current()), ak_dim)  AS artikel_dimension,
      COALESCE(lang_artmat(ag_aknr, ReportLang_current()), ak_mat)  AS artikel_materialnummer,
      ak_din                                                        AS artikel_materialnorm,
      ag_stk_uf1*ak_gewicht                                         AS artikel_pos_gewicht,
      ag_rust                                                       AS artikel_kost_rust,
      ag_fert                                                       AS artikel_kost_fert,
      ag_mat                                                        AS artikel_kost_mat,
      ag_awkost                                                     AS artikel_kost_aw,
      ak_warencode                                                  AS artikel_warencode,
      ak_fertigung                                                  AS artikel_fert,
      (SELECT lang_land( ak_l_iso, ReportLang_current() ))          AS artikel_ursprung,

      ag_done                                                       AS done,
      ag_storno                                                     AS storno,
      CASE WHEN (ag_astat = 'E') AND ('K' IN (ag_bstat, ag_bstat1, ag_bstat2)) THEN false
      ELSE  ag_nstatistik END                                       AS optional, --#9337 PHKO

      ag_kurs                                                       AS kurs_waer,
      ag_preis                                                      AS preis_me_netto, --ag_vkp
      ag_preiseinheit                                               AS preiseinheit, -- 6447, 6772
      ag_vkp_uf1                                                    AS preis_me_netto_uf1,
      ag_vkp_basis_w                                                AS preis_me_netto_basis_w,
      ag_vkp_uf1_basis_w                                            AS preis_me_netto_basis_w_uf1,
      COALESCE(ag_vkp_mce, ag_mcv)                                  AS preis_mengeneinheit_artmgc_id, -- 7678
      lang_artmgc_id_iso(COALESCE(ag_vkp_mce, ag_mcv), ReportLang_current())   AS preis_mengeneinheit_bez_iso, -- 7678
      ag_netto                                                      AS preis_inkl_rabatt_abzu,
      ag_brutto                                                     AS preis_inkl_rabatt_abzu_steuer,
      ag_preis*IFTHEN(ag_canrabatt, (1-ag_arab/100), 1)             AS preis_me_inkl_posrabatt_ohne_abzu, --ag_vkp
      ag_ep_netto                                                   AS preis_me_inkl_rabatt_ohne_abzu,

      auftg_pos_wert_calc(ag_id, false, false, true)                AS preis_positionswert_nur_hauptpos_werthaltig,
      (SELECT SUM(az_anz*az_abzubetrag) FROM auftgabzu WHERE az_ag_id=ag_id)
                                                                    AS preis_pos_abzusum,

      ag_vkptotalpos OR auftg_get_auftgmainpos(ag_id, true) IS NULL AS poshatvkp,

      ag_ustpr                                                      AS steuproz,

      ag_stk                                                        AS menge,
      ((tartikel.me__menge_uf1__in__menge(COALESCE(ag_vkp_mce, ag_mcv), ag_stk_uf1))/Do1If0(ag_stk))::NUMERIC(12,4) AS menge_1in_preiseinheit,  -- 7678 Umrechnungsfaktor: 1 Einheit der Menge entspricht 1 Einheit der Menge des Preises
      NULL::FLOAT                                                   AS menge_rahmen_abrlos,
      ag_stk_uf1                                                    AS menge_uf1,
      ag_stkl                                                       AS menge_geliefert_uf1,
      ag_stkf                                                       AS menge_verrechnet,
      --ag_stk_offen                                                        AS menge_offen_mengeneinheit,
      ag_stkl-ag_stk_uf1                                            AS menge_offen_uf1,
      ag_arab                                                       AS rabatt,
      ag_rabhint                                                    AS rabatt_hint,
      atd_gesrab                                                    AS rabatt_ges,
      ag_mcv                                                        AS mengeneinheit_artmgc_id,
      lang_artmgc_id_iso(ag_mcv, ReportLang_current())              AS mengeneinheit_bez_iso,

      COALESCE(IFTHEN(Trim(ag_txt_rtf)='', NULL::TEXT, ag_txt_rtf), ag_txt)::TEXT AS postxt_rtf,

      ag_an_nr                                                      AS an_nr,
      (SELECT an_bez FROM anl WHERE an_nr=ag_an_nr)                 AS an_bez,

      ag_kdatum                                                     AS datum_geplant,
      ag_ldatum                                                     AS datum_bestaetigt,
      COALESCE(ag_ldatum, ag_kdatum)                                AS datum_coalesce_bestaetigt_geplant,

      ag_ldatumtext                                                 AS datum_text,
      NULL::DATE                                                    AS datum_woche_geplant,
      ag_twa                                                        AS datum_woche_bestaetigt,
      ag_twa                                                        AS datum_woche,
      ag_aldatum                                                    AS datum_auslieferung,

      null::integer                                                 AS p_q_nr

     FROM
      auftg JOIN art ON ak_nr=ag_aknr
            LEFT JOIN auftgdokutxt ON atd_dokunr=ag_dokunr
            LEFT JOIN artzuo ON az_id=(SELECT az_id FROM artzuo WHERE az_prokrz=ag_lkn AND az_pronr=ag_aknr ORDER BY az_gdatum DESC LIMIT 1)
     ORDER BY
      ag_astat, ag_nr, ag_pos;

    -- Nachtrag Auftragsbestätigung Positionen
    CREATE OR REPLACE VIEW treporting.auftg_beleg_positionennachtrag AS
      SELECT
        tartikel.me__menge_uf1__in__menge(auftg.ag_mcv, auftg.ag_stk_uf1) AS referenz_menge
        , tartikel.me__menge_uf1__in__menge(auftg.ag_mcv, ifthen(auftg.ag_done, auftg.ag_stk_uf1, auftg.ag_stkl)) AS referenz_menge_erledigt
        , ag_id AS id
       FROM auftg
      WHERE NOT ag_done
    ;

    DROP VIEW IF EXISTS treporting.auftg_belegnachtrag_kopfdaten;
    DROP VIEW IF EXISTS treporting.auftg_beleg_kopfdaten;
    CREATE OR REPLACE VIEW treporting.auftg_beleg_kopfdaten AS
     SELECT
       atd_dokunr::VARCHAR                                                  AS dokument_id,                         --wegen FR auf Varchar casten, dort wird dokument_id mit dokument_nummer verglichen
       atd_dokunr                                                           AS dokument_join_id,
       atd_dokunr                                                           AS dokument_abzu_join_id,
       IFTHEN((SELECT count(1) FROM (SELECT ag_nr FROM auftg WHERE ag_dokunr=atd_dokunr GROUP BY ag_nr) AS a)=1    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer
              ,(SELECT ag_nr FROM auftg WHERE ag_dokunr=atd_dokunr LIMIT 1)
              ,atd_dokunr::VARCHAR(50))
                                                                            AS dokument_nummer,
       atd_dokunr                                                           AS dokument_dms_id,
       NULL::NUMERIC                                                        AS dokument_anzahlprozent,
       ag_astat                                                             AS dokument_status,

       (SELECT count(1) FROM (SELECT ag_nr FROM auftg WHERE ag_dokunr=atd_dokunr GROUP BY ag_nr) AS a)>1 AS dokument_multidok, --mehrere unterschiedliche Nummern auf einem Dokument?
       true                                                                 AS definitiv,

       IFTHEN(ag_astat='A','aufadok','aufedok')::VARCHAR(10)                AS doktype_force,   -- war bis 21.07.14 auftg_dok

       atd_datum                                                            AS dokument_erstelldatum,

       IFTHEN(ag_astat='A', 'trans.kopf.ihreanfrage', 'trans.kopf.ihrebestellung')::VARCHAR(75)
                                                                            AS dokument_reftitkunde,
       IFTHEN(ag_astat='A', 'trans.kopf.unserangebot', 'trans.kopf.unserauftrag')::VARCHAR(75)
                                                                            AS dokument_reftiteigen,
       'trans.kopf.anfragenr'::VARCHAR(75)                                  AS dokument_reftiteigen1,

       CASE WHEN atd_titel IS NOT NULL THEN atd_titel
         ELSE
           CASE WHEN (SELECT count(1) FROM (SELECT ag_nr FROM auftg WHERE ag_dokunr=atd_dokunr GROUP BY ag_nr) AS a)=1 THEN    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer
             CASE WHEN (ag_astat='R') OR ((ag_astat='E') AND (ag_pos=0)) THEN 'trans.kopf.rahmenauftgbest'
                  WHEN (ag_astat = 'E') AND ('K' IN (ag_bstat, ag_bstat1, ag_bstat2)) THEN 'trans.kopf.konsignationsauftgbest' -- #9337 Konsignationsauftrag
               ELSE IFTHEN(ag_astat='A', 'trans.kopf.angebot', 'trans.kopf.auftgbest')
             END
           ELSE
             CASE WHEN (ag_astat='R') OR ((ag_astat='E') AND (ag_pos=0)) THEN 'trans.kopf.rahmenauftgbestdok'
               ELSE IFTHEN(ag_astat='A', 'trans.kopf.angebotdok', 'trans.kopf.auftgbestdok')
             END
         END
       END                                                                  AS dokument_titel,

       CASE WHEN (SELECT count(1) FROM (SELECT ag_nr FROM auftg WHERE ag_dokunr=atd_dokunr GROUP BY ag_nr) AS a)=1 THEN    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer
           CASE WHEN (ag_astat='R') OR ((ag_astat='E') AND (ag_pos=0)) THEN 'trans.kopf.rahmenauftgbest'
                WHEN (ag_astat = 'E') AND ('K' IN (ag_bstat, ag_bstat1, ag_bstat2)) THEN 'trans.kopf.konsignationsauftgbest' -- #9337 Konsignationsauftrag
             ELSE IFTHEN(ag_astat='A', 'trans.kopf.angebot', 'trans.kopf.auftgbest')
           END
       ELSE
           CASE WHEN (ag_astat='R') OR ((ag_astat='E') AND (ag_pos=0)) THEN 'trans.kopf.rahmenauftgbestdok'
             ELSE IFTHEN(ag_astat='A', 'trans.kopf.angebotdok', 'trans.kopf.auftgbestdok')
           END
       END::varchar(100)                                                    AS dokument_titel_doktype,
       COALESCE(atd_txt_rtf, atd_txt)                                       AS dokument_kopftext,
       COALESCE(atd_txt1_rtf, atd_txt1)                                     AS dokument_fusstext,
       NULL::TEXT                                                           AS dokument_qhint,

       IFTHEN(a1_export, COALESCE(a1_export_adktxt_rtf,belarzu__zu_tit__gettxt('EXPORT-INT')), IFTHEN(a1_euexport,COALESCE(a1_export_adktxt_rtf, belarzu__zu_tit__gettxt('EXPORT-EU')), NULL))::TEXT
                                                                            AS dokument_exporttxt,
       IFTHEN(a1_ursprungstxt, COALESCE(a1_ursprungstxt_adktxt_rtf, belarzu__zu_tit__gettxt('EXPORT-URSPRUNG')), NULL)::TEXT
                                                                            AS dokument_exportursprungtxt,
       belarzu__zu_tit__gettxt('DOKU_EMAILTXT', ReportLang_current(), false)
                                                                            AS dokument_emailtxt,

       ((SELECT count(1) FROM (SELECT DISTINCT ag_nr, COALESCE(ag_bda,''), COALESCE(ag_an_nr,'') FROM auftg WHERE ag_dokunr=atd_dokunr) AS a)) AS dokument_positiongroupcount, --eine gleiche referenz über alles?

       atd_apkrzl                                                           AS dokument_adresse_ansprechpartner_adressant_ident,
       atd_ap                                                               AS dokument_adresse_ansprechpartner_adressant,
       ap_anr                                                               AS dokument_adresse_ansprechpartner_adressant_anr,
       ap_sex_man::VARCHAR(1)                                               AS dokument_adresse_ansprechpartner_adressant_man, -- 't' Herr, 'f' Frau, NULL > kein AP
       ap_name                                                              AS dokument_adresse_ansprechpartner_adressant_nachname,
       ap_vorn                                                              AS dokument_adresse_ansprechpartner_adressant_vorname,
       ap_sysfun                                                            AS dokument_adresse_ansprechpartner_adressant_sysfun,
       ap_titel                                                             AS dokument_adresse_ansprechpartner_adressant_titel,
       ap_abteilung                                                         AS dokument_adresse_ansprechpartner_adressant_abteilung,

       ag_lkn                                                               AS dokument_adresse_adressant,
       adk_ad_krz                                                           AS dokument_adresse_ident, --zB dbrid für Parameter

       ad_ustidnr                                                           AS ustidnr,

       sum_auftg_dokunr(atd_dokunr)                                         AS dokument_summe_netto,
       sum_auftg_dokunr(atd_dokunr, true)                                   AS dokument_summe_brutto,

       atd_fixwert                                                          AS dokument_fixwert,
       atd_gesrab                                                           AS dokument_gesamtrabatt,

       (SELECT sum_auftg_dokunr( atd_dokunr, false, false ) - sum_auftg_dokunr( atd_dokunr, false ))
                                                                            AS dokument_gesamtrabatt_wert,


       --atd_bindefrist                                                       AS dokument_bindefrist,
       IFTHEN(ag_astat='E', NULL::VARCHAR, atd_bindefrist)                  AS dokument_bindefrist,

       atd_apint                                                            AS dokument_adresse_ap_intern_ident,
       nameAufloesen(atd_apint)                                             AS dokument_adresse_ap_intern_name,
       atd_apint2                                                           AS dokument_adresse_ap_intern_ident2,
       nameAufloesen(atd_apint2)                                            AS dokument_adresse_ap_intern_name2,
       COALESCE(ap_mail, ad_email1)                                         AS adresse_adressant_email,

       a1_knr::VARCHAR(50)                                                  AS dokument_adresse_knr_debi_or_kredi,  --PRODAT Kundennummer
       a1_eknr::VARCHAR(50)                                                 AS dokument_adresse_adressant_knr_debi_or_kredi,
       ag_waer                                                              AS zahlung_waco,
       a1_spco                                                              AS sprache_debi_or_kredi,
       a1_tolfrueh                                                          AS lieftolfrueh_debi_or_kredi,
       a1_tolspaet                                                          AS lieftolspaet_debi_or_kredi,
       a1_euexport                                                          AS euexport,
       a1_export                                                            AS intexport,
       NULL::VARCHAR                                                        AS zazexport,   --ZAZ Nummer; nur für Zoll, daher nur Rechnung und Lieferschein
       NULL::VARCHAR                                                        AS eori_vertragspartner,    --EORI des Kunden

       atd_zak                                                              AS zahlung_tage_zahlungbis,
       atd_skv                                                              AS zahlung_tage_skontoverfall,
       atd_sks                                                              AS zahlung_skontosatz_prozent,

       lang_za(a1_zahlart,ReportLang_current())                             AS zahlung_zahlart_name_debikredidat,
       atd_zakbem                                                           AS zahlung_zahlkondition_bemerkung,

       kto_bknr,
       kto_blz,
       kto_bank,
       kto_bic,
       kto_iban,
       kto_pckonto,
       kto_bb,

       (SELECT s_bb FROM adkspco WHERE a1_spco = s_spco)                    AS s_bb, --Hintergrund-Einstellung aus Sprache NEU

       atd_v_id                                                             AS versand_versandart_ident,
       COALESCE(lang_versart(v_id, ReportLang_current() ), atd_vers)        AS versand_versandart,  --COALESCE(v_descr,atd_vers)
       atd_versandort                                                       AS versand_versandort,-- Ort des Gefahrenübergangs
       COALESCE(atd_versandbem_rtf, atd_versandbem)                         AS versand_bem,
       (SELECT (TAdk.DokVersandTyp(ad_dokversand)).ad_DokVersandBez FROM adk WHERE adk.ad_krz=adk_ad_krz)
                                                                            AS dokument_versand, -- Dokumenten-Versandbezeichnung Adressstammdaten

       (SELECT MAX(ag_preiseinheit) FROM auftg WHERE ag_dokunr=atd_dokunr)  AS preiseinheit_max,
       (SELECT MAX(LENGTH(ag_hwpos)) FROM auftg WHERE ag_dokunr=atd_dokunr) AS hwpos_max, --Strukturposition
       (SELECT MAX(LENGTH(ag_bdapos)) FROM auftg WHERE ag_dokunr=atd_dokunr) AS bdapos_max, --Länge Bestellpostion Kunde #12607

       (SELECT MAX(numeric_larger(LENGTH((ag_stk-trunc(ag_stk))::FLOAT::VARCHAR)-2,0)) FROM auftg WHERE ag_dokunr=atd_dokunr)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                                            AS dokument_menge_numdigits,
       (SELECT MAX(numeric_larger(LENGTH((ag_preis-trunc(ag_preis))::FLOAT::VARCHAR)-2,0)) FROM auftg WHERE ag_dokunr=atd_dokunr AND (ag_vkptotalpos OR auftg_get_auftgmainpos(ag_id, true) IS NULL))
                                                                            AS dokument_vkp_numdigits,
       (SELECT MAX(numeric_larger(LENGTH(((ag_preis*(1-ag_arab/100))-trunc((ag_preis*(1-ag_arab/100))))::FLOAT::VARCHAR)-2,2)) FROM auftg WHERE ag_dokunr=atd_dokunr)
                                                                            AS dokument_arab_numdigits
     FROM
       auftgdokutxt LEFT JOIN auftg         ON ag_id = (SELECT ag_id FROM auftg WHERE ag_dokunr = atd_dokunr ORDER BY ag_pos LIMIT 1) --treporting.auftg_beleg_positionen ON atd_dokunr=belegdokumentnummer
                    LEFT JOIN auftgtxt      ON at_astat = ag_astat AND at_nr = ag_nr
                    LEFT JOIN adressen_view ON ad_krz = ag_krzf --wegen Debitorendaten
                    LEFT JOIN adk1          ON a1_krz = adk_ad_krz --debitorendaten zur Adresse
                    LEFT JOIN ktovz         ON kto_name = a1_ktv_name OR (a1_ktv_name IS NULL AND kto_std)
                    LEFT JOIN adkap         ON ag_lkn = ap_ad_krz AND ap_krzl = atd_apkrzl AND ap_krzl IS NOT NULL
                    LEFT JOIN versart       ON v_art ILIKE atd_vers; --LIKE-JOIN http://redmine.prodat-sql.de/issues/4981#note-6

    -- Nachtrag Auftragsbestätigung Kopfdaten
    CREATE OR REPLACE VIEW treporting.auftg_belegnachtrag_kopfdaten AS
     SELECT
            coalesce(atd_nachtitel, 'trans.kopf.auftgnachtrag'::varchar(75))    AS dokument_titel,
            'auftg_nachtrag_dok'::varchar(20)                                   AS doktype_force,
            atd_nachdat                                                         AS dokument_erstelldatum,
            coalesce(atd_nachtxt_rtf, atd_nachtxt)                              AS dokument_kopftext,
            coalesce(atd_nachtxt1_rtf, atd_nachtxt1)                            AS dokument_fusstext,
            dokument_id AS id
       FROM
            treporting.auftg_beleg_kopfdaten JOIN auftgdokutxt ON dokument_join_id = atd_dokunr;


    DROP VIEW IF EXISTS treporting.auftg_abzuschlaege_pos;
    CREATE OR REPLACE VIEW treporting.auftg_abzuschlaege_pos AS
     SELECT
            az_ag_id                                                      AS position_id,
            az_abz_id                                                     AS abzuid,
            lang_abzu(az_abz_id, ReportLang_current())                    AS bezeichnung,
            az_type                                                       AS typ, --                          #7938 PHKO
            az_pos                                                        AS pos, --                          #7938 PHKO
            az_anz                                                        AS anzahl,
            az_abzubetrag                                                 AS preis,
            az_anz*az_abzubetrag                                          AS preis_wert_netto,
            az_abzuproz                                                   AS prozent,
            az_steucode                                                   AS steuercode,
            az_steuproz                                                   AS steuerprozent,
            az_visible                                                    AS sichtbar,
            coalesce(az_zutxt_rtf, az_zutxt)                              AS bemerkung, --                    #7938 PHKO #9255 GEO
            az_zutxt_int                                                  AS bemerkung_intern, --             #7938 PHKO
            (SELECT max(numeric_larger(length(abs(az_anz-trunc(az_anz))::float::varchar) - 2, 0)) FROM auftgabzu WHERE az_ag_id = ag_id)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                                          AS abzu_menge_numdigits,
            (SELECT max(numeric_larger(length(abs(az_abzubetrag - trunc(az_abzubetrag))::float::varchar) - 2, 0)) FROM auftgabzu WHERE az_ag_id = ag_id)
                                                                          AS abzu_preis_numdigits
       FROM
            auftgabzu
       JOIN auftg ON ag_id = az_ag_id
      UNION
     SELECT
            aprt_agid                                                     ,--AS position_id,
            NULL                                                          ,--AS  AbzuId,
            coalesce(NullIf(TRIM(apr_doktxt), ''), aprt_bez)              ,--AS bezeichnung,
            NULL                                                          ,--AS typ,                      #7938 PHKO
            NULL                                                          ,--AS pos,                      #7938 PHKO
            1                                                             ,--AS anzahl,
            NULL                                                          ,--AS preis,
            NULL                                                          ,--AS preis_wert_netto,
            NULL                                                          ,--AS prozent,
            NULL                                                          ,--AS steuercode,
            NULL                                                          ,--AS steuerprozent,
            TRUE                                                          ,--AS sichtbar,
            aprt_txt                                                      ,--AS bemerkung,
            NULL                                                          ,--AS bemerkung_intern,          #7938 PHKO
            NULL                                                          ,--AS abzu_menge_numdigits,
            NULL                                                           --AS abzu_preis_numdigits
       FROM
            artPruefungTest LEFT JOIN artpruefung ON aprt_apr_id=apr_id
      WHERE
            apr_aufdok AND apr_abz_id NOT IN (SELECT az_abz_id FROM auftgabzu WHERE aprt_agid=az_ag_id)/*Ausschliessen von Datensätzen, die bereits durch Abzuschlag auf Dokument*/
      ORDER BY 
            pos, bezeichnung;


    DROP VIEW IF EXISTS treporting.auftg_abzuschlaege_beleg;
    CREATE OR REPLACE VIEW treporting.auftg_abzuschlaege_beleg AS
     SELECT
            az_global_dokunr                                              AS dokument_abzu_join_id,
            lang_abzu(az_abz_id, prodat_languages.curr_lang())            AS bezeichnung, -- TODO: prodat_languages.customerlang(ag_lkn)
            az_type                                                       AS typ, --                          #7938 PHKO
            az_pos                                                        AS pos, --                          #7938 PHKO
            az_anzahl                                                     AS anzahl,
            az_betrag                                                     AS preis,
            round(az_anzahl * az_betrag, 2)                               AS preis_wert_netto,
            az_proz                                                       AS prozent,
            az_scode                                                      AS steuercode,
            az_sproz                                                      AS steuerprozent,
            az_visible                                                    AS sichtbar,
            coalesce(az_txt_rtf,az_txt)                                   AS bemerkung, --                    #7938 PHKO #9255 GEO
            az_txt_int                                                    AS bemerkung_intern --              #7938 PHKO
       FROM TWawi.Auftg_Abzu
      WHERE az_parent_id IS null -- nur Belegbezogen, hat keinen Positionsbezug
        AND az_global_dokunr IS NOT null
      ORDER BY 
            pos, bezeichnung;

    DROP VIEW IF EXISTS treporting.auftg_steuerartenbetrag;    
    CREATE OR REPLACE VIEW treporting.auftg_steuerartenbetrag AS
     SELECT
        dokument_id,
        steucode,
        steuproz,
        round( sum(steubetrag), 2) AS steubetrag,
        steubez
      FROM
      (SELECT
        ag_dokunr                                                     AS dokument_id,
        ag_steucode                                                   AS steucode,
        ag_ustpr                                                      AS steuproz,
        round( sum(round(ag_brutto, 2) - round(ag_netto, 2) 
                   - coalesce( (SELECT sum(  round(  round(az_betrag * az_anzahl, 2) * az_sproz / 100, 2 ) )
                                  FROM TWawi.Auftg_Abzu 
                                 WHERE az_parent_id = auftg.ag_id 
                                   AND NOT (az_scode = auftg.ag_steucode AND az_sproz = auftg.ag_ustpr) 
                                )
                              ,0 
                              ) 
                   )
              , 2
              ) AS steubetrag,
        coalesce( lang_steu(ag_steucode, ReportLang_current()), lang_steu(ag_steucode, prodat_languages.curr_lang()) )
                                                                      AS steubez
        FROM auftg
       WHERE
         NOT ag_nstatistik 
         AND ag_ustpr IS NOT NULL 
         AND  NOT ag_storno 
         AND (NOT ag_vkptotalpos OR NOT EXISTS(SELECT true FROM auftg a1 --Preis enthält Unterposition nur dann = 0, wenn auch Unterposition, sonst einbeziehen
                                                WHERE a1.ag_astat  = auftg.ag_astat 
                                                  AND a1.ag_nr     = auftg.ag_nr 
                                                  AND a1.ag_hpos   = auftg.ag_pos 
                                                  AND a1.ag_dokunr = auftg.ag_dokunr
                                               )
             )
       GROUP BY
        ag_dokunr, ag_steucode, ag_ustpr, steubez

       UNION

       -- Abzuschläge, welche abweichende Steuern zur Position haben?!???
       SELECT
        ag_dokunr                                                     AS dokument_id,
        az_scode                                                      AS steucode,
        az_sproz                                                      AS steuproz,
        sum(  round(  round(az_betrag * az_anzahl, 2) * az_sproz / 100, 2 ) ) AS steubetrag,
        coalesce( lang_steu(az_scode, ReportLang_current()), lang_steu(az_scode, prodat_languages.curr_lang()) )
                                                                      AS steubez
       FROM
        TWawi.Auftg_Abzu
        JOIN auftg ON ag_id = az_parent_id 
         AND NOT (az_scode = ag_steucode AND az_sproz = ag_ustpr)
         AND NOT ag_nstatistik 
         AND NOT ag_vkptotalpos 
         AND NOT ag_storno
       GROUP BY
         ag_dokunr, 
         az_scode, az_sproz, steubez


       UNION

       -- Globale Abzuschläge
       SELECT
        az_global_dokunr                                              AS dokument_id, -- globaler Abzuschlag OHNE Positionszuordnung!
        az_scode                                                      AS steucode,
        az_sproz                                                      AS steuproz,
        sum(  round(  round(az_betrag * az_anzahl, 2) * az_sproz / 100, 2 ) ) AS steubetrag,
        coalesce( lang_steu(az_scode, ReportLang_current()), lang_steu(az_scode, prodat_languages.curr_lang()) )
                                                                      AS steubez
       FROM
        auftg 
        JOIN auftgtxt ON at_astat = ag_astat AND at_nr = ag_nr
        JOIN TWawi.Auftg_Abzu ON at_id = az_beleg_id
         AND az_parent_id IS null -- globaler Abzu OHNE Positionsbezug!
       GROUP BY
         az_global_dokunr, az_scode, az_sproz, steubez

      ) AS summe
     GROUP BY
              dokument_id, steucode, steuproz, steubez
      ;


END $$ LANGUAGE plpgsql;

--SELECT TSystem.views__ReportingAuftg__recreate();
